/**********************************************************************/
/*                   V O I C E . C                                    */
/**------------------------------------------------------------------**/
/* Task           : Demonstrates accessing the Creative Labs          */
/*                  driver using the "Text to Speech"                 */
/*                  driver.                                           */
/**------------------------------------------------------------------**/
/* Author          : Michael Tischer / Bruno Jennrich                 */
/* Developed on    : 03/20/1994                                       */
/* Last update     : 03/25/1994                                       */
/**------------------------------------------------------------------**/
/* COMPILER       : Borland C++ 3.1, Micsosoft Visual C++ 1.5         */
/**********************************************************************/

/*- Add Include files ----------------------------------------*/
#include <stdio.h>
#include <process.h>

#include "sbutil.h"
#include "ctts.h"
#include "args.h"

/*- Remove the following lines within a project: -------------*/
#include "sbutil.c"
#include "ctts.c"
#include "args.c"

/**********************************************************************/
/*          M A I N   P R O G R A M                                   */
/**********************************************************************/
VOID main( INT argc, PCHAR argv[] )
{ LPVOID lpEntry;                               /* Driver entry point */
  INT iGender, iTone, iVolume, iPitch, iSpeed;
  PCHAR pText;

  iGender = 0;                                              /* Gender */
  iGender = GetArg( argc, argv, "-FEMALE", _none, NULL, 0 );
  iTone = 0;                                                  /* Tone */
  iTone = GetArg( argc, argv, "-TREBLE", _none, NULL, 0 );
  iVolume = 5;                                              /* Volume */
  GetArg( argc, argv, "-VOL:", _int, &iVolume, 1 );
  iPitch = 5;                                                /* Pitch */
  GetArg( argc, argv, "-PITCH:", _int, &iPitch, 1 );
  iSpeed = 5;                                                /* Speed */
  GetArg( argc, argv, "-SPEED:", _int, &iSpeed, 1 );

  pText = NULL;
  GetNArg( argc, argv, "-", ( PCHAR *)&pText, 1 );
  if( pText == NULL )
  {
    printf("Call: voice TEXT [ -FEMALE][ -TREBLE]" );
    printf("[ -VOL:0-9][ -PITCH:0-9][ -SPEED:0-9 ]\n" );
    exit( 0 );
  }

  lpEntry = sb_LoadDriver( "CTTS.DRV" );          /* Load CTTS driver */

  if( !lpEntry )  printf("Could not find \"CTTS.DRV\"!\n");
  else
  {
    if( ctts_GetEnvSettings( lpEntry ) )  /* Set environment variable */
      printf("Error in BLASTER environment variable");
    else
    if( ctts_Init( lpEntry ) )                   /* Initialize driver */
        printf("Could not initialize CTTS");
    else
    { WORD ver;
      ver = ctts_GetDrvVer( lpEntry );          /* Get version number */
      printf(" CTTS version: %02d.%02d\n", ver >> 8, ver & 0xff);

      ctts_SetSpeechParam( lpEntry,          /* Set speech parameters */
                           ( BYTE ) iGender,
                           ( BYTE ) iTone,
                           ( BYTE ) iVolume,
                           ( BYTE ) iPitch,
                           ( BYTE ) iSpeed );
      ctts_Say( lpEntry, pText );              /* Speak your piece... */
      ctts_Terminate( lpEntry );                           /* and end */
    }
    sb_UnloadDriver( lpEntry );
  }
}
